/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.recipe;

import java.util.Arrays;
import java.util.Collection;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.recipe.BaseRecipeTypeMapper;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;

@RecipeTypeMapper(priority=-2147483648)
public class FallbackRecipeTypeMapper
extends BaseRecipeTypeMapper {
    @Override
    public String getName() {
        return "FallbackRecipeType";
    }

    @Override
    public String getDescription() {
        return "Fallback for default handling of recipes that extend ICraftingRecipe, AbstractCookingRecipe, SingleItemRecipe, or SmithingRecipe. This will catch modded extensions of the vanilla recipe classes, and if the VanillaRecipeTypes mapper is disabled, this mapper will still catch the vanilla recipes.";
    }

    @Override
    public boolean canHandle(RecipeType<?> recipeType) {
        return true;
    }

    @Override
    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, Recipe<?> recipe, INSSFakeGroupManager fakeGroupManager) {
        if (recipe instanceof CraftingRecipe || recipe instanceof AbstractCookingRecipe || recipe instanceof SingleItemRecipe || recipe instanceof UpgradeRecipe) {
            return super.handleRecipe(mapper, recipe, fakeGroupManager);
        }
        return false;
    }

    @Override
    protected Collection<Ingredient> getIngredients(Recipe<?> recipe) {
        Collection<Ingredient> ingredients = super.getIngredients(recipe);
        if (recipe instanceof UpgradeRecipe) {
            UpgradeRecipe upgradeRecipe = (UpgradeRecipe)recipe;
            if (ingredients.isEmpty()) {
                return Arrays.asList(upgradeRecipe.f_44518_, upgradeRecipe.f_44519_);
            }
        }
        return ingredients;
    }
}

